<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

abstract class GetIntegrationOrders extends Command
{
    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Retrieve Orders from a sales channel';

    /**
     * Check command options values.
     *
     * @return bool
     */
    public function checkOptions()
    {
        if (! is_numeric($this->option('limit'))) {
            $this->error('The limit options must be an integer value');

            return false;
        }

        if ($this->option('createdAfter') and ! strtotime($this->option('createdAfter'))) {
            $this->error('The createdAfter option must be a valid date format');

            return false;
        }

        if ($this->option('createdBefore') and ! strtotime($this->option('createdBefore'))) {
            $this->error('The createdBefore option must be a valid date format');

            return false;
        }

        if ($this->option('lastUpdatedAfter') and ! strtotime($this->option('lastUpdatedAfter'))) {
            $this->error('The lastUpdatedAfter option must be a valid date format');

            return false;
        }

        if ($this->option('lastUpdatedBefore') and ! strtotime($this->option('lastUpdatedBefore'))) {
            $this->error('The lastUpdatedBefore option must be a valid date format');

            return false;
        }

        return true;
    }
}
