<?php

namespace App\Console\Commands;

use App\Jobs\FixFifoLayerQuantityCacheJob;
use Exception;
use Illuminate\Console\Command;

/**
 * @deprecated by FixInvalidFifoLayerFulfilledQuantityCache (called from InvalidFifoLayerFulfilledQuantityCache)
 */
class FixFifoLayerQuantityCache extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:fifo-layers:fix-cache
                            {--p|products=* : Specify products }';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Fixes/Invalidates the fulfilled quantity field of fifo layers';

    /**
     * Execute the console command.
     *
     * @throws Exception
     */
    public function handle(): int
    {
        $bar = $this->output->createProgressBar();

        // Get the fifo layers out of sync (fulfilled quantity doesn't match total inventory movement qty).
        [$invalid, $fifoLayersNotFixed] = (new FixFifoLayerQuantityCacheJob($this->option('products')))->setProgressBar($bar)->handle();

        $this->info("\nCache fixed for ".count($invalid).' fifo layers.');

        if (count($fifoLayersNotFixed)) {
            $this->info('fifo Layers we could not fix');
            $this->table(['ID', 'Error'], $fifoLayersNotFixed);
        }

        return 0;
    }
}
