<?php

namespace App\Console\Commands\Financials;

use App\Jobs\CalculateDailyFinancialsJob;
use Illuminate\Console\Command;

class CalculateDailyFinancialsCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:financials:daily:calculate';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Calculate Daily Financials';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        dispatch(new CalculateDailyFinancialsJob())->onQueue('financials');
    }
}
