<?php

namespace App\Console\Commands\Ebay;

use App\Models\SalesChannel;
use App\Models\SalesChannelType;
use Exception;
use Illuminate\Console\Command;

class GetProducts extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:ebay:get-products {salesChannel}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Get Products from specific sales channel.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @throws Exception
     */
    public function handle(): void
    {
        $sales_channel = SalesChannel::with('type')->findOrFail($this->argument('salesChannel'));

        if (SalesChannelType::getTypeByID($sales_channel->sales_channel_type_id) !== SalesChannelType::TYPE_EBAY) {
            $this->error('Sales Channel must be Ebay type.');

            return;
        }

        \App\Jobs\Ebay\GetProducts::dispatch($sales_channel);
    }
}
