<?php

namespace App\Console\Commands\Ebay;

use App\Models\SalesChannel;
use App\Models\SalesChannelType;

class GetOrders extends \App\Console\Commands\GetOrders
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sku:ebay:get-orders {salesChannel}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Get Orders from specific sales channel.';

    /**
     * The console command Sales Channel Type.
     *
     * @var string
     */
    protected $salesChannelType = SalesChannelType::TYPE_EBAY;

    /**
     * Execute the console command of Sales channel type.
     */
    public function handleCommand(SalesChannel $salesChannel): void
    {
        \App\Jobs\Ebay\GetOrders::dispatch($salesChannel);
    }
}
