<?php

namespace App\Console\Commands;

use App\Repositories\ApiLogRepository;
use Illuminate\Console\Command;

class DeleteOldApiLogsCommand extends Command
{
    protected $signature = 'sku:delete:old-api-logs';

    protected $description = 'Delete API Logs older than 7days';

    public function handle(): void
    {
        app(ApiLogRepository::class)->deleteLogsOlderThan(7);

        $this->info('Old api_logs records deleted successfully.');
    }
}
