<?php

namespace App\Actions\InventoryManagement;

use App\Data\FifoLayerQuantityData;
use App\Exceptions\InventoryMovementTypeException;
use App\Models\InventoryMovement;
use App\Repositories\InventoryHealthRepository;
use App\Services\StockTake\OpenStockTakeException;
use Illuminate\Support\Collection;
use Spatie\LaravelData\DataCollection;

class CreateReservedInventoryMovementFromActive
{
    protected InventoryMovement $activeMovement;
    protected DataCollection|FifoLayerQuantityData $fifoLayerData;
    protected Collection $createdMovements;

    public function __construct(
        private readonly InventoryHealthRepository $health,
    )
    {
    }

    /**
     * @throws OpenStockTakeException
     * @throws InventoryMovementTypeException
     */
    public function __invoke(InventoryMovement $activeMovement): Collection
    {
        $this->activeMovement   = $activeMovement;
        $this->createdMovements = collect();

        $this->createReservedInventoryMovements();

        return $this->createdMovements;
    }

    /**
     * @throws OpenStockTakeException
     * @throws InventoryMovementTypeException
     */
    private function createReservedInventoryMovements(): void
    {
        $this->createdMovements->push($this->health->createReservationInventoryMovementFromActiveMovement(
            $this->activeMovement,
        ));
    }
}
