<?php

namespace App\Actions\InventoryHealth;

use App\Models\FifoLayer;
use App\Models\SalesOrderLine;
use App\Repositories\SalesOrderLineLayerRepository;
use App\Services\FinancialManagement\SalesOrderLineFinancialManager;
use Exception;

class UpdateSalesOrderLineLayerCache
{
    protected SalesOrderLine $salesOrderLine;
    protected FifoLayer $fifoLayer;
    protected int $qtyChange;

    public function __construct(
        private readonly SalesOrderLineFinancialManager $salesOrderLineFinancialManager,
        private readonly SalesOrderLineLayerRepository $lineLayers,
    )
    {
    }

    /**
     * @throws Exception
     */
    public function __invoke(
        SalesOrderLine $salesOrderLine,
        FifoLayer $fifoLayer,
        int $qtyChange,
    ): void
    {
        $this->salesOrderLine = $salesOrderLine;
        $this->fifoLayer = $fifoLayer;
        $this->qtyChange = $qtyChange;
        $this->updateLayers();
        $this->updateCache();

    }

    private function updateLayers(): void
    {
        $eligibleLineLayers = $this->lineLayers->getLayersForSalesOrderLineFifoLayer($this->salesOrderLine, $this->fifoLayer);
        while ($this->qtyChange !== 0 && $lineLayer = $eligibleLineLayers->shift()) {
            $qtyToChange = min(abs($lineLayer->quantity), abs($this->qtyChange));
            $lineLayer->quantity += $qtyToChange;
            $lineLayer->save();
            $this->qtyChange -= $qtyToChange;
        }
    }

    /**
     * @throws Exception
     */
    private function updateCache(): void
    {
        $this->salesOrderLineFinancialManager->calculateAndCacheFinancials(collect([$this->salesOrderLine]));
        $this->salesOrderLine->updated_at = now();
        $this->salesOrderLine->save();
    }
}
