<?php

namespace App\Actions\InventoryHealth;

use App\Models\FifoLayer;
use App\Models\Product;
use App\Models\SalesOrderLine;
use Throwable;

class FixNonInventoryProductWithInventoryMovements
{
    protected Product $product;

    public function __construct()
    {
    }

    public function __invoke(
        Product $product
    ): void
    {
        $this->product = $product;

        $this->deleteFifoLayers();
        $this->deleteBackorders();
    }

    private function deleteFifoLayers(): void
    {
        $this->product->fifoLayers?->each(function (FifoLayer $fifoLayer) {
            $fifoLayer->delete();
        });
    }

    private function deleteBackorders(): void
    {
        $this->product->salesOrderLines->each(/**
         * @throws Throwable
         */ function (SalesOrderLine $salesOrderLine) {
            $salesOrderLine->backorderQueue?->delete();
        });
    }
}
