<?php

namespace App\Abstractions\Integrations\SalesChannels;

use App\Collections\ProductListingCollection;
use Illuminate\Database\Eloquent\Collection;
use Spatie\LaravelData\DataCollection;

interface SalesChannelProductManagerInterface
{
    public function createSkuProducts(array $productIds = [], bool $createForAll = false): void;

    public function makeProductListingCollectionForImport(Collection $salesChannelProducts, bool $collectionHasProductIdColumn = false): DataCollection;

    public function setDataMappings(): void;
}
