<?php

namespace App\Abstractions\Integrations\SalesChannels;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Abstractions\Integrations\IntegrationModelInterface;
use App\Collections\ProductImageCollection;
use App\DTO\ProductDto;
use App\DTO\ProductPricingDto;
use App\Models\ProductPricingTier;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphOne;
use Spatie\LaravelData\DataCollection;

interface SalesChannelProductInterface extends IntegrationModelInterface
{
    public function integrationInstance(): BelongsTo;

    public function productListing(): MorphOne;

    public static function getIntegrationName(): string;

    public function getProductDto(): ProductDto;

    public function getPricing(): DataCollection;

    public function getImages(): DataCollection;

    public function applyDataMapping(mixed $data, string $mappedColumn): mixed; // TODO: Review this... and maybe abstract it to AbstractSalesChannelProduct

    public function manager(IntegrationInstanceInterface $integrationInstance): SalesChannelProductManagerInterface;

    public function refreshAdt(): ApiDataTransformerInterface;

    public static function repository(): SalesChannelProductRepositoryInterface;
}
