<?php

namespace App\Abstractions\Integrations\SalesChannels;

use App\DataTable\NewDataTableResource;

class SalesChannelProductDataTableResource extends NewDataTableResource
{
    public function getCustomColumns(): array
    {
        return [
            'integration_instance_id' => $this->inclusive('integration_instance_id', $this->resource->integration_instance_id),
            'product_listing_id' => $this->inclusive('product_listing_id', $this->resource->productListing?->id),
            'product' => $this->inclusive('product',
                $this->resource->productListing?->product->only('id', 'name', 'sku')),
            'mapped_at' => $this->inclusive('mapped_at',
                (is_null($this->resource->productListing) ? null : $this->resource->productListing->created_at)),
            'mapped_sku' => $this->inclusive('mapped_sku', $this->resource->productListing?->product->sku),
            'json_object' => $this->inclusive('json_object', $this->resource->json_object),
        ];
    }
}