<?php

namespace App\Abstractions\Integrations\SalesChannels;

use App\Data\SalesOrderLineData;
use App\Models\IntegrationInstance;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;

interface SalesChannelOrderLineInterface
{
    public function order(): BelongsTo;

    public function product(): BelongsTo|\Awobaz\Compoships\Database\Eloquent\Relations\BelongsTo;

    public function salesOrderLine(): HasOne;

    public function getSalesOrderLineData(): SalesOrderLineData;

    public function getWarehouseId(): ?int;

    public function getNominalCodeId(): ?int;

    public function getAmount(): float;

    public function getTaxAllocation(): float;

    public function getDiscountAllocation(): float;

    public function scopeWithProduct(Builder $builder, IntegrationInstance $integrationInstance);

    public function salesChannelProductClass(): string;

    public static function getSalesChannelProductUniqueId(): string;

    public static function getUniqueId(): string;

    public static function getTableUniqueId(): string;

    public static function getLineItemsKey(): ?string;

    public static function getParentRelationId(): string;
}
