<?php

namespace App\Abstractions\Integrations\SalesChannels;

use App\DataTable\NewDataTableResource;

class SalesChannelOrderDataTableResource extends NewDataTableResource
{
    public function getCustomColumns(): array
    {
        return [
            'integration_instance_id' => $this->inclusive('integration_instance_id', $this->resource->integration_instance_id),
            'sku_sales_order' => $this->resource->salesOrder ? [
                'id' => $this->resource->salesOrder->id,
                'number' => $this->resource->salesOrder->sales_order_number,
            ] : null,
            'json_object' => $this->inclusive('json_object', $this->resource->json_object),
        ];
    }
}