<?php

namespace App\Abstractions\Integrations\SalesChannels;

use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Http\Controllers\Controller;
use App\Models\SalesOrderFulfillment;
use App\Response;
use Illuminate\Http\Request;

abstract class AbstractSalesChannelFulfillmentController extends Controller
{
    abstract protected function getModel(): string;

    public function abstractFulfill(Request $request, IntegrationInstanceInterface $integrationInstance): Response
    {
        $request->validate([
            'sales_order_fulfillment_id' => 'required|integer|exists:sales_order_fulfillments,id',
        ]);
        $salesOrderFulfillment = SalesOrderFulfillment::findOrFail($request->sales_order_fulfillment_id);
        app($this->getModel())->manager($integrationInstance)->fulfillOrderForSalesOrderFulfillment($salesOrderFulfillment);

        return $this->response->setMessage('Successfully submitted to sales channel.');
    }
}
