<?php

namespace App\Abstractions\Integrations\Data;

use App\Data\SalesChannelInventorySettingsData;
use App\Data\SalesChannelPricingSettingsData;
use App\Helpers;
use App\Models\Setting;
use Spatie\LaravelData\Attributes\Validation\Exists;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;
use Spatie\LaravelData\Support\Validation\ValidationContext;

class SalesChannelIntegrationSettingsData extends Data
{
    public function __construct(
        public string $start_date,
        #[Exists('stores', 'id')]
        public int $store_id,
        public bool $auto_link_products,
        public bool $auto_create_products,
        #[Exists('nominal_codes', 'id')]
        public ?int $sales_nominal_code_id,
        #[Exists('nominal_codes', 'id')]
        public ?int $cogs_nominal_code_id,
        public SalesChannelPricingSettingsData|Optional $pricing,
        public SalesChannelInventorySettingsData|Optional $inventory,
        public bool $emailCustomers = false,
        public ?float $proforma_marketplace_cost_percentage = null,
        public ?float $proforma_payment_cost_percentage = null,
        public bool $sync_sales_order_invoices_to_accounting = true
    )
    {
    }

    public static function rules(ValidationContext $context): array
    {
        return [
            'start_date' => 'required|string|after_or_equal:'.Helpers::setting(Setting::KEY_INVENTORY_START_DATE, null, true),
        ];
    }
}
