<?php

namespace App\Abstractions\Integrations\Data;

use Spatie\LaravelData\Data;

abstract class AbstractJsonObjectData extends Data
{
    public array $json_object;

    public static function from(...$payloads): static
    {
        array_walk(
            $payloads,
            function (array &$singlePayload) {
                $singlePayload['json_object'] = $singlePayload;
            }
        );

        return parent::from(
            ...$payloads,
        );
    }
}
