<?php

namespace App\Abstractions\Integrations\Accounting;

use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Models\Supplier;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection as EloquentCollection;
use Illuminate\Support\Collection;
use Spatie\LaravelData\Data;

interface AccountingVendorRepositoryInterface
{
    public function saveForIntegration(IntegrationInstanceInterface $integrationInstance, Collection $vendors): void;

    public function getStartDateForNew(IntegrationInstanceInterface $integrationInstance): Carbon;

    public function getVendorsNeedingUpdate(array $supplier_ids = []): EloquentCollection;

    public function syncVendor(IntegrationInstanceInterface $integrationInstance, Supplier $supplier, Data $payload): AbstractAccountingVendor;
}
