<?php

namespace App\Abstractions\Integrations\Accounting;

use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Models\Payment;
use Illuminate\Database\Eloquent\Collection as EloquentCollection;
use Illuminate\Support\Collection;

interface AccountingPaymentRepositoryInterface
{
    public function getPaymentsNeedingUpdate(array $paymentIds, string $paymentType, ?int $limit = null): EloquentCollection;

    public function getPaymentsNeedingDelete(array $paymentIds, ?int $limit = null): EloquentCollection;

    public function saveAndGetRecordsForIntegration(IntegrationInstanceInterface $integrationInstance, Collection $records): EloquentCollection;

    public function linkPaymentWithAccountingPayment(Payment $skuPayment, AbstractAccountingModel $accountingPayment): void;

    public function deletePayments(array $paymentIds): void;
}
