<?php

namespace App\Abstractions\Integrations\Accounting;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use App\Abstractions\Integrations\ClientResponseDataInterface;

interface AccountingClientInterface
{
    public function getAccounts(ApiDataTransformerInterface $parameters): ClientResponseDataInterface;

    public function getInvoices(ApiDataTransformerInterface $parameters): ClientResponseDataInterface;

    public function getPurchaseOrders(ApiDataTransformerInterface $parameters): ClientResponseDataInterface;

    public function getPayments(ApiDataTransformerInterface $parameters): ClientResponseDataInterface;

    public function getTaxRates(ApiDataTransformerInterface $parameters): ClientResponseDataInterface;

    public function getTaxCodes(ApiDataTransformerInterface $parameters): ClientResponseDataInterface;

    public function getVendors(ApiDataTransformerInterface $parameters): ClientResponseDataInterface;

    public function createVendor(ApiDataTransformerInterface $parameters): ClientResponseDataInterface;

    public function createProduct(ApiDataTransformerInterface $parameters): ClientResponseDataInterface;

    public function createCustomer(ApiDataTransformerInterface $parameters): ClientResponseDataInterface;

    public function deletePayments(ApiDataTransformerInterface $parameters): ClientResponseDataInterface;
}
