<?php

namespace App\Abstractions\Integrations\Accounting;

use App\DataTable\DataTable;
use App\Http\Controllers\Controller;
use App\Response;
use Illuminate\Contracts\Queue\ShouldQueue;

abstract class AbstractAccountingTaxRateController extends Controller
{
    use DataTable;

    abstract protected function getModel(): string;

    abstract protected function getResource(): string;

    public function abstractRefresh(ShouldQueue $refreshJob): Response
    {
        dispatch($refreshJob)->onQueue('accounting');

        return $this->response->setMessage('Added to queue, tax codes will be refreshed shortly.');
    }
}
