<?php

namespace App\Abstractions\Integrations\Accounting;

use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Models\IntegrationInstance;
use Awobaz\Compoships\Compoships;
use Awobaz\Compoships\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Model;

/**
 * @property-read IntegrationInstanceInterface $integrationInstance
 */
abstract class AbstractAccountingModel extends Model implements AccountingAccountInterface
{
    use Compoships;

    public function integrationInstance(): BelongsTo
    {
        return $this->belongsTo(IntegrationInstance::class);
    }
}
