<?php

namespace App\Abstractions\Integrations;

use App\Abstractions\AbstractRepository;
use Illuminate\Database\Eloquent\Collection as EloquentCollection;
use Illuminate\Support\Collection;

abstract class AbstractIntegrationRepository extends AbstractRepository
{
    abstract public function getModelClassName(): string;

    protected IntegrationModelInterface $model;

    public function __construct()
    {
        /** @var IntegrationModelInterface $model */
        $this->model = app($this->getModelClassName());
    }

    public function saveForIntegration(IntegrationInstanceInterface $integrationInstance, Collection $data): void
    {
        $data = $data->map(function ($product) use ($integrationInstance) {
            return [
                'integration_instance_id' => $integrationInstance->id,
                'json_object' => json_encode($product->json_object),
            ];
        });

        $this->model::upsert($data->toArray(), ['integration_instance_id', $this->model::getUniqueField()]);
    }

    public function saveAndGetRecordsForIntegration(IntegrationInstanceInterface $integrationInstance, Collection $data): EloquentCollection
    {
        $this->saveForIntegration($integrationInstance, $data);

        return $this->model::query()
            ->whereIn($this->model::getUniqueField(), $data->pluck($this->model::getUniqueField()))
            ->where('integration_instance_id', $integrationInstance->id)
            ->get();
    }
}
