<?php

namespace App\Abstractions\Integrations;

use App\Models\Product;
use Exception;

abstract class AbstractIntegrationManager
{
    /**
     * @throws Exception
     */
    public function __construct(protected IntegrationInstanceInterface $integrationInstance, protected IntegrationClientInterface $client)
    {
    }

    public function refreshData(ApiDataTransformerInterface $parameters, callable $fetchFunction, callable $saveFunction): ClientResponseDataInterface
    {
        $responseDto = $fetchFunction($parameters);

        if ($responseDto->collection->count()) {
            $saveFunction($this->integrationInstance, $responseDto->collection);
        }

        return $responseDto;
    }
}
