<?php

namespace App\Abstractions\Integrations;

use App\Enums\IntegrationInstanceSyncStatusEnum;
use App\Models\ApiLog;
use App\Models\Integration;
use App\Models\IntegrationInstanceServiceDisruptions;
use App\Models\SalesChannel;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

// TODO: Move from IntegrationInstance to this class
abstract class AbstractIntegrationInstance extends Model implements IntegrationInstanceInterface
{
    use HasFactory;

    protected $table = 'integration_instances';

    protected $primaryKey = 'id';

    protected $guarded = [];

    protected $casts = [
        'connection_settings' => 'array',
        'integration_settings' => 'array',
        'is_automatic_sync_enabled' => 'boolean',
        'sync_status' => IntegrationInstanceSyncStatusEnum::class,
    ];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function integration(): BelongsTo
    {
        return $this->belongsTo(Integration::class, 'integration_id');
    }

    public function salesChannel(): HasOne
    {
        return $this->hasOne(SalesChannel::class, 'integration_instance_id');
    }

    public function apiLogs(): HasMany
    {
        return $this->hasMany(ApiLog::class, 'integration_instance_id');
    }

    public function integrationInstanceServiceDisruptions(): HasMany
    {
        return $this->hasMany(IntegrationInstanceServiceDisruptions::class, 'integration_instance_id');
    }
}