<?php

namespace App\Abstractions\Integrations;

use Exception;

abstract class AbstractAccountingIntegrationManager
{
    /**
     * @throws Exception
     */
    public function __construct(protected IntegrationInstanceInterface $integrationInstance)
    {
    }

    public function refreshData(ApiDataTransformerInterface $parameters, callable $fetchFunction, callable $saveFunction): ClientResponseDataInterface
    {
        $responseDto = $fetchFunction($parameters);

        if ($responseDto->collection->count()) {
            $saveFunction($this->integrationInstance, $responseDto->collection);
        }

        return $responseDto;
    }
}
