<?php

namespace App\Abstractions;

use App\Abstractions\Integrations\AbstractIntegrationInstanceRepository;
use App\Abstractions\Integrations\Data\AuthenticationAuthorizationResponseInterface;
use App\Abstractions\Integrations\IntegrationClientInterface;
use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Http\Controllers\Controller;
use Exception;

abstract class AbstractAuthenticationCallbackController extends Controller
{
    abstract public function getIntegrationInstanceRepository(): AbstractIntegrationInstanceRepository;

    abstract public function getClient(IntegrationInstanceInterface $integrationInstance): IntegrationClientInterface;

    abstract public function getStateParameterName(): string;

    public function getIntegrationInstanceIdFromState(string $state): int
    {
        // Note I am using a _ instead of a | because of experience with WooCommerce purging the | character when not logged in
        [$subdomain, $integrationInstanceId] = explode('_', $state);

        return $integrationInstanceId;
    }

    public function getIntegrationInstanceFromState(string $state): IntegrationInstanceInterface
    {
        return $this->getIntegrationInstanceRepository()->getById($this->getIntegrationInstanceIdFromState($state));
    }

    /**
     * @throws Exception
     */
    public function abstractCallback(AuthenticationAuthorizationResponseInterface $data): IntegrationInstanceInterface
    {
        $integrationInstance = $this->getIntegrationInstanceFromState($data->{$this->getStateParameterName()});
        $this->getIntegrationInstanceRepository()->updateConnectionSettings($integrationInstance, $data->toArray());

        return $integrationInstance;
    }
}
