<?php

/** @noinspection PhpArrayShapeAttributeCanBeAddedInspection */

namespace Modules\Xero\Transformers;

use App\DataTable\DataTableResource;
use Illuminate\Http\Request;
use Modules\Xero\Entities\XeroAccount;

/**
 * @mixin XeroAccount
 */
class XeroAccountResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  Request
     */
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'AccountID' => $this->inclusive('AccountID', $this->AccountID),
            'Name' => $this->inclusive('Name', $this->Name),
            'Code' => $this->inclusive('Code', $this->Code),
            'Type' => $this->inclusive('Type', $this->Type),
            'Status' => $this->inclusive('Status', $this->Status),
            'Class' => $this->inclusive('Class', $this->Class),
            'nominal_code_name' => $this->inclusive('nominal_code_name', $this->whenLoaded('nominalCode', function () {
                return $this->nominalCode->name;
            })),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('created_at', $this->updated_at),
        ];
    }
}
