<?php

namespace Modules\Xero\Tests;

use App\Models\Integration;
use App\Models\IntegrationInstance;
use App\Models\User;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Queue;
use Laravel\Sanctum\Sanctum;
use Tests\TestCase;

class XeroTest extends TestCase
{
    use WithFaker;

    protected function setUp(): void
    {
        parent::setUp();
        Queue::fake();

        Sanctum::actingAs(User::factory()->create());

        $integration = Integration::query()->whereName(Integration::NAME_XERO)->first();

        // Create the Xero integration
        IntegrationInstance::query()->firstOrCreate(
            ['name' => Integration::NAME_XERO,],
            [
                'name' => Integration::NAME_XERO,
                'connection_settings' => [
                    'clientId' => $this->faker->md5(),
                    'clientSecret' => $this->faker->numberBetween(1, 10),
                ],
                'integration_id' => $integration ? $integration->id : Integration::factory()->create([
                    'name' => Integration::NAME_XERO,
                    'integration_type' => Integration::TYPE_ACCOUNTING,
                ]),
                'integration_settings' => []
            ]
        );
        IntegrationInstance::factory()->create();

        // Ensure that all external api requests are mocked.
        Http::preventStrayRequests();

    }

    protected function mockConnectionRequests()
    {
        Http::fake([
            'identity.xero.com/connect/token' => Http::response([
                'access_token' => $this->faker->sha1(),
                'refresh_token' => $this->faker->sha1(),
                'id_token' => $this->faker->sha1(),
                'expires_in' => now()->addDays(5)->unix(),
            ]),
            'api.xero.com/connections' => Http::response([
                ['tenantId' => $this->faker->sha1()],
            ]),
        ]);
    }

    protected function mockEndpoint(string $endpoint, array $response = [], array $headers = [])
    {
        $endpoint = ltrim($endpoint, '/');
        Http::fake([
            "api.xero.com/api.xro/2.0/$endpoint" => Http::response(
                body: json_encode($response),
                headers: $headers + [
                    'X-DayLimit-Remaining' => 100,
                ]
            ),
        ]);
    }
}
