<?php

namespace Modules\Xero\Tests\Feature;

use App\Enums\IntegrationInstanceSyncStatusEnum;
use App\Managers\IntegrationInstanceManager;
use App\Notifications\IntegrationInstanceSyncStatusInactiveNotification;
use App\Repositories\IntegrationInstanceRepository;
use App\Repositories\UserRepository;
use Modules\Xero\Exceptions\XeroReauthorizeException;
use Modules\Xero\Tests\XeroTest;
use Notification;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;

class XeroExceptionTest extends XeroTest
{
    use FastRefreshDatabase;

    public function test_xero_reauthorize_exception()
    {
        Notification::fake();

        $integrationInstance = app(IntegrationInstanceRepository::class)->getAccountingInstance();

        app(IntegrationInstanceManager::class)->updateSyncStatus($integrationInstance, IntegrationInstanceSyncStatusEnum::ACTIVE);

        try {
            throw new XeroReauthorizeException($integrationInstance);
        } catch (\Exception $e) {
        }

        $this->assertTrue($integrationInstance->sync_status === IntegrationInstanceSyncStatusEnum::INACTIVE);

        (new UserRepository())->getAdminUsers()->each(function ($user) {
            Notification::assertSentTo(
                notifiable: $user,
                notification: IntegrationInstanceSyncStatusInactiveNotification::class,
            );
        });
    }
}
