<?php

namespace Modules\Xero\Jobs;

use Illuminate\Support\Collection;
use Modules\Xero\Repositories\XeroTransactionRepository;

class XeroUpdateOrCreateInvoicesJob extends XeroJob
{
    public int $timeout = 60 * 30;

    public int $tries = 5;

    private Collection $transactions;

    public function __construct(Collection $transactions)
    {
        $this->onQueue('xero');
        $this->transactions = $transactions;

        parent::__construct();
    }

    public function apiCall()
    {
        app(XeroTransactionRepository::class)->updateOrCreateInvoices($this->transactions);
    }
}
