<?php

namespace Modules\Xero\Jobs;

class XeroSyncTransactionsJob extends XeroJob
{
    public int $timeout = 60 * 30;

    public int $tries = 5;

    private array $accounting_transaction_ids;

    public function __construct(array $accounting_transaction_ids = [])
    {
        $this->onQueue('xero');
        $this->accounting_transaction_ids = $accounting_transaction_ids;

        parent::__construct();
    }

    public function apiCall()
    {
        $this->manager->syncTransactions($this->accounting_transaction_ids);
    }
}
