<?php

namespace Modules\Xero\Jobs;

use Modules\Xero\Exceptions\XeroReauthorizeException;

class XeroSyncSuppliersJob extends XeroJob
{
    private array $supplier_ids;

    public function __construct(array $supplier_ids = [])
    {
        $this->supplier_ids = $supplier_ids;

        parent::__construct();
    }

    public function apiCall()
    {
        try {
            $this->manager->syncSuppliers($this->supplier_ids);
        } catch (XeroReauthorizeException $e) {
            $this->fail('Xero reauthorization required');
        }
    }
}
