<?php

namespace Modules\Xero\Jobs;

use App\Exceptions\ApiException;
use GuzzleHttp\Exception\GuzzleException;
use Modules\Xero\Exceptions\XeroTimeoutException;
use Modules\Xero\Managers\XeroManager;
use Spatie\DataTransferObject\Exceptions\UnknownProperties;

class XeroGetTransactionsJob extends XeroJob
{
    private array $accounting_transaction_ids;

    public function __construct(array $accounting_transaction_ids = [])
    {
        $this->accounting_transaction_ids = $accounting_transaction_ids;

        parent::__construct();
    }

    /**
     * Execute the job.
     *
     * @throws UnknownProperties
     * @throws ApiException
     * @throws XeroTimeoutException
     * @throws GuzzleException
     */
    public function apiCall()
    {
        $manager = app(XeroManager::class);
        $manager->getTransactions($this->accounting_transaction_ids);
    }
}
