<?php

namespace Modules\Xero\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Response;
use Exception;
use Modules\Xero\Exceptions\XeroReauthorizeException;
use Modules\Xero\Exceptions\XeroTimeoutException;
use Modules\Xero\Managers\XeroManager;
use Spatie\DataTransferObject\Exceptions\UnknownProperties;

class XeroContactController extends Controller
{
    public function __construct(
        private readonly XeroManager $manager,
    ) {
        parent::__construct();
    }

    /**
     * @throws UnknownProperties
     * @throws Exception
     */
    public function sync(): ?Response
    {
        try {
            $this->manager->syncSuppliers();
        } catch (XeroReauthorizeException $e) {
            return $this->response->addError(
                'Xero authorization has expired and must be reauthorized.',
                'XeroReauthorize',
                'XeroReauthorize'
            );
        } catch (XeroTimeoutException $e) {
            return $this->response->addError(
                $e->getMessage(),
                'XeroTimeout',
                'XeroTimeout'
            );
        }

        return $this->response->success(200);
    }
}
