<?php

namespace Modules\Xero\Entities;

use App\Models\TaxRate;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphOne;
use Modules\Xero\Database\factories\XeroTaxRateFactory;

/**
 * @property int $id
 * @property string $Name
 * @property string $TaxType,
 * @property float $EffectiveRate,
 * @property array $json_object
 * @property-read TaxRate $taxRate
 * @property Carbon $updated_at
 * @property Carbon $created_at
 */
class XeroTaxRate extends Model
{
    use HasFactory;

    protected $fillable = [
        'json_object',
    ];

    protected $casts = [
        'json_object' => 'array',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function taxRate(): MorphOne
    {
        return $this->morphOne(TaxRate::class, 'accountingIntegration');
    }

    public static function newFactory(): XeroTaxRateFactory
    {
        return XeroTaxRateFactory::new();
    }
}
