<?php

namespace Modules\Xero\Database\factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Xero\Entities\XeroTaxRate;

class XeroTaxRateFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = XeroTaxRate::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        return [
            'json_object' => [
                'Name' => $this->faker->unique()->word(),
                'TaxType' => $this->faker->randomElement(['TAX001', 'TAX002', 'TAX003']),
                'EffectiveRate' => $this->faker->randomFloat(4, 0, 100),
            ]
        ];
    }
}
