<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('xero_manual_journals', function (Blueprint $table) {
            $table->id();
            $table->string('ManualJournalID')->unique()->nullable();
            $table->dateTime('DateUTC');
            $table->dateTime('UpdatedDateUTC');
            $table->string('Status')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.Status'))");
            $table->string('Narration')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.Narration'))")->index();
            $table->json('json_object')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('xero_manual_journals');
    }
};
