<?php

namespace Modules\Xero\DTO;

use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class XeroPayment extends Data
{
    public function __construct(
        public string|Optional $PaymentID,
        public array|Optional $Invoice,
        public array|Optional $Account,
        public string|Optional $Date,
        public float|Optional $Amount,
        public string|Optional|null $Reference,
        public bool|Optional $IsReconciled,
        public float|Optional $CurrencyRate,
        public string|Optional $Status,
        public array|Optional $json_object,
        public string|Optional $StatusAttributeString,
        public array|Optional $ValidationErrors,
    ) {
    }

    const STATUS_AUTHORISED = 'AUTHORISED';

    const STATUS_DELETED = 'DELETED';
}
