<?php

namespace Modules\Xero\DTO;

use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class XeroJournalLine extends Data
{
    public function __construct(
        public string|Optional $JournalLineID,
        public string|Optional $Description,
        public float|Optional $LineAmount,
        public string|Optional $AccountCode,
        public string|Optional $TaxType,
        public float|Optional $TaxAmount,
    ) {
    }

    const TAX_TYPE_INPUT = 'INPUT';

    const TAX_TYPE_NONE = 'NONE';

    const TAX_TYPE_OUTPUT = 'OUTPUT';

    const TAX_TYPE_GST_ON_IMPORTS = 'GSTONIMPORTS';
}
