<?php

namespace Modules\WooCommerce\Tests;

class WooCommerceTestingData
{
    public static function getProducts(): array
    {
        return [self::getProduct()];
    }

    /**
     * The array returned here correctly mimics the data returned by
     * https://woocommerce.github.io/woocommerce-rest-api-docs/#list-all-products
     * However, it is only returning a single product rather than array of products.
     * This is a Simple product (Not a variable product with variants)
     */
    public static function getProduct(): array
    {
        return [
            'id' => 17,
            'name' => 'Test Two',
            'slug' => 'test-two',
            'permalink' => 'https://wp.skudev.io/product/test-two/',
            'date_created' => '2022-12-06T20:22:53',
            'date_created_gmt' => '2022-12-06T14:52:53',
            'date_modified' => '2022-12-20T10:07:30',
            'date_modified_gmt' => '2022-12-20T04:37:30',
            'type' => 'simple',
            'status' => 'publish',
            'featured' => false,
            'catalog_visibility' => 'visible',
            'description' => '',
            'short_description' => '',
            'sku' => 'TEST_TWO',
            'price' => '15',
            'regular_price' => '19.95',
            'sale_price' => '15',
            'date_on_sale_from' => null,
            'date_on_sale_from_gmt' => null,
            'date_on_sale_to' => null,
            'date_on_sale_to_gmt' => null,
            'on_sale' => true,
            'purchasable' => true,
            'total_sales' => 0,
            'virtual' => false,
            'downloadable' => false,
            'downloads' => [],
            'download_limit' => -1,
            'download_expiry' => -1,
            'external_url' => '',
            'button_text' => '',
            'tax_status' => 'taxable',
            'tax_class' => '',
            'manage_stock' => false,
            'stock_quantity' => null,
            'backorders' => 'no',
            'backorders_allowed' => false,
            'backordered' => false,
            'low_stock_amount' => null,
            'sold_individually' => false,
            'weight' => '',
            'dimensions' => [
                'length' => '',
                'width' => '',
                'height' => '',
            ],
            'shipping_required' => true,
            'shipping_taxable' => true,
            'shipping_class' => '',
            'shipping_class_id' => 0,
            'reviews_allowed' => true,
            'average_rating' => '0.00',
            'rating_count' => 0,
            'upsell_ids' => [],
            'cross_sell_ids' => [],
            'parent_id' => 0,
            'purchase_note' => '',
            'categories' => [
                [
                    'id' => 15,
                    'name' => 'Uncategorized',
                    'slug' => 'uncategorized',
                ],
            ],
            'tags' => [],
            'images' => [],
            'attributes' => [],
            'default_attributes' => [],
            'variations' => [],
            'grouped_products' => [],
            'menu_order' => 0,
            'price_html' => '<del aria-hidden="true"><span class="woocommerce-Price-amount amount"><bdi><span class="woocommerce-Price-currencySymbol">&#36;</span>20.00</bdi></span></del> <ins><span class="woocommerce-Price-amount amount"><bdi><span class="woocommerce-Price-currencySymbol">&#36;</span>18.00</bdi></span></ins>',
            'related_ids' => [
                11,
            ],
            'meta_data' => [],
            'stock_status' => 'instock',
            'has_options' => false,
            '_links' => [
                'self' => [
                    [
                        'href' => 'https://wp.skudev.io/wp-json/wc/v3/products/17',
                    ],
                ],
                'collection' => [
                    [
                        'href' => 'https://wp.skudev.io/wp-json/wc/v3/products',
                    ],
                ],
            ],
        ];
    }

    public static function getOrders(): array
    {
        return [self::getOrder()];
    }

    /**
     * The array returned here correctly mimics the data returned by
     * https://woocommerce.github.io/woocommerce-rest-api-docs/#list-all-orders
     * However, it is only returning a single order rather than array of orders.
     *
     * TODO: Return array of orders
     */
    public static function getOrder(): array
    {
        return [
            'id' => 18,
            'parent_id' => 0,
            'status' => 'pending',
            'currency' => 'USD',
            'version' => '7.1.0',
            'prices_include_tax' => false,
            'date_created' => '2022-12-06T20:24:10',
            'date_modified' => '2022-12-07T19:45:03',
            'discount_total' => '0.00',
            'discount_tax' => '0.00',
            'shipping_total' => '0.00',
            'shipping_tax' => '0.00',
            'cart_tax' => '0.00',
            'total' => '66.00',
            'total_tax' => '6.00',
            'customer_id' => 0,
            'order_key' => 'wc_order_Wd0zEG8Kbz6ll',
            'billing' => [
                'first_name' => '',
                'last_name' => '',
                'company' => '',
                'address_1' => '',
                'address_2' => '',
                'city' => '',
                'state' => '',
                'postcode' => '',
                'country' => '',
                'email' => '',
                'phone' => '',
            ],
            'shipping' => [
                'first_name' => '',
                'last_name' => '',
                'company' => '',
                'address_1' => '',
                'address_2' => '',
                'city' => '',
                'state' => '',
                'postcode' => '',
                'country' => '',
                'phone' => '',
            ],
            'payment_method' => '',
            'payment_method_title' => '',
            'transaction_id' => '',
            'customer_ip_address' => '',
            'customer_user_agent' => '',
            'created_via' => 'admin',
            'customer_note' => '167042250253623286',
            'date_completed' => null,
            'date_paid' => null,
            'cart_hash' => '',
            'number' => '18',
            'meta_data' => [],
            'line_items' => [
                [
                    'id' => 3,
                    'name' => 'Test One',
                    'product_id' => 11,
                    'variation_id' => 0,
                    'quantity' => 10,
                    'tax_class' => '',
                    'subtotal' => '30.00',
                    'subtotal_tax' => '3.00',
                    'total' => '30.00',
                    'total_tax' => '3.00',
                    'taxes' => [
                        [
                            'id' => 1,
                            'total' => '0.30',
                            'subtotal' => '0.30',
                        ],
                        [
                            'id' => 2,
                            'total' => '2.70',
                            'subtotal' => '2.70',
                        ]
                    ],
                    'meta_data' => [],
                    'sku' => '',
                    'price' => 0,
                    'image' => [
                        'id' => '',
                        'src' => '',
                    ],
                    'parent_name' => null,
                ],
                [
                    'id' => 4,
                    'name' => 'Test Two',
                    'product_id' => 17,
                    'variation_id' => 0,
                    'quantity' => 5,
                    'tax_class' => '',
                    'subtotal' => '30.00',
                    'subtotal_tax' => '3.00',
                    'total' => '30.00',
                    'total_tax' => '3.00',
                    'taxes' => [
                        [
                            'id' => 3,
                            'total' => '1.80',
                            'subtotal' => '1.80',
                        ],
                        [
                            'id' => 4,
                            'total' => '1.20',
                            'subtotal' => '1.20',
                        ]
                    ],
                    'meta_data' => [],
                    'sku' => '',
                    'price' => 0,
                    'image' => [
                        'id' => '',
                        'src' => '',
                    ],
                    'parent_name' => null,
                ],
            ],
            'tax_lines' => [
                [
                    'id' => 23,
                    'rate_code' => 'US-TAX_01',
                    'rate_id' => 1,
                    'label' => 'tax_01',
                    'compound' => false,
                    'tax_total' => '0.30',
                    'shipping_tax_total' => '0.00',
                    'rate_percent' => 1,
                    'meta_data' => [],
                ],
                [
                    'id' => 24,
                    'rate_code' => 'US-TAX_09',
                    'rate_id' => 2,
                    'label' => 'tax_09',
                    'compound' => false,
                    'tax_total' => '2.70',
                    'shipping_tax_total' => '0.00',
                    'rate_percent' => 9,
                    'meta_data' => [],
                ],
                [
                    'id' => 25,
                    'rate_code' => 'US-TAX_04',
                    'rate_id' => 3,
                    'label' => 'tax_04',
                    'compound' => false,
                    'tax_total' => '1.20',
                    'shipping_tax_total' => '0.00',
                    'rate_percent' => 4,
                    'meta_data' => [],
                ],
                [
                    'id' => 26,
                    'rate_code' => 'US-TAX_06',
                    'rate_id' => 4,
                    'label' => 'tax_06',
                    'compound' => false,
                    'tax_total' => '1.80',
                    'shipping_tax_total' => '0.00',
                    'rate_percent' => 6,
                    'meta_data' => [],
                ],
            ],
            'shipping_lines' => [],
            'fee_lines' => [],
            'coupon_lines' => [],
            'refunds' => [],
            'payment_url' => 'https://wp.skudev.io/checkout/order-pay/18/?pay_for_order=true&key=wc_order_Wd0zEG8Kbz6ll',
            'is_editable' => true,
            'needs_payment' => false,
            'needs_processing' => true,
            'date_created_gmt' => '2022-12-06T14:54:10',
            'date_modified_gmt' => '2022-12-07T14:15:03',
            'date_completed_gmt' => null,
            'date_paid_gmt' => null,
            'currency_symbol' => '$',
            '_links' => [
                'self' => [
                    [
                        'href' => 'https://wp.skudev.io/wp-json/wc/v3/orders/18',
                    ],
                ],
                'collection' => [
                    [
                        'href' => 'https://wp.skudev.io/wp-json/wc/v3/orders',
                    ],
                ],
            ],
        ];
    }

    public static function getOrderNote(): array
    {
        return [
            "id" => 5731,
            "author" => "WooCommerce",
            "date_created" => "2024-04-24T14:05:16",
            "date_created_gmt" => "2024-04-24T14:05:16",
            "note" => "test note",
            "customer_note" => false,
            "_links" => [
                "self" => [
                    [
                        "href" => "https://www.240sxconversions.com/wp-json/wc/v3/orders/3267/notes/5731"
                    ]
                ],
                "collection" => [
                    [
                        "href" => "https://www.240sxconversions.com/wp-json/wc/v3/orders/3267/notes"
                    ]
                ],
                "up" => [
                    [
                        "href" => "https://www.240sxconversions.com/wp-json/wc/v3/orders/3267"
                    ]
                ]
            ]
        ];
    }
}
