<?php

namespace Modules\WooCommerce\Tests;

use Http;

trait WooCommerceMockRequests
{
    public function mockRefreshOrders(): void
    {
        Http::fake([
            '*/orders?*' => Http::response(WooCommerceTestingData::getOrders()),
        ]);
    }

    public function mockRefreshOrder(): void
    {
        Http::fake([
            '*/orders/*' => Http::response(WooCommerceTestingData::getOrder()),
        ]);
    }

    public function mockRefreshProducts(): void
    {
        Http::fake([
            '*/products?*' => Http::response(WooCommerceTestingData::getProducts()),
        ]);
    }

    public function mockFulfillOrder(): void
    {
        Http::fake([
            '*/orders/*/notes' => Http::response(WooCommerceTestingData::getOrderNote()),
        ]);
        Http::fake([
            '*/orders/*' => Http::response(WooCommerceTestingData::getOrder()),
        ]);
    }
}
