<?php

namespace Modules\WooCommerce\Tests\Feature\Managers;

use App\Models\AccountingTransaction;
use App\Models\SalesChannel;
use App\Models\SalesOrder;
use App\Services\Accounting\AccountingTransactionManager;
use Illuminate\Foundation\Testing\WithFaker;
use Modules\WooCommerce\Entities\WooCommerceIntegrationInstance;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class WooCommerceIntegrationInstanceManagerTest extends TestCase
{
    use FastRefreshDatabase;
    use WithFaker;

    private WooCommerceIntegrationInstance $wooCommerceIntegrationInstance;

    public function setUp(): void
    {
        parent::setUp();

        $this->wooCommerceIntegrationInstance = WooCommerceIntegrationInstance::factory([
            'is_automatic_sync_enabled' => true,
            'integration_settings' => [
                'sync_sales_order_invoices_to_accounting' => false,
            ],
        ])->has(SalesChannel::factory())
            ->create();
    }

    public function test_it_will_change_accounting_transactions_when_sync_sales_order_settings_changed(): void
    {
        $salesChannel = $this->wooCommerceIntegrationInstance->salesChannel;

        $salesOrder = SalesOrder::factory([
            'sales_channel_id' => $salesChannel->id,
        ])->create();

        app(AccountingTransactionManager::class)->sync();

        $this->assertDatabaseHas(AccountingTransaction::class, [
            'link_type' => SalesOrder::class,
            'link_id' => $salesOrder->id,
            'is_sync_enabled' => false,
        ]);

        $settings                                                   = $this->wooCommerceIntegrationInstance->integration_settings;
        $settings['sync_sales_order_invoices_to_accounting']        = true;
        $this->wooCommerceIntegrationInstance->integration_settings = $settings;
        $this->wooCommerceIntegrationInstance->save();

        app(AccountingTransactionManager::class)->syncAccountingTransactionsSalesOrderIsSyncEnabledStatus($this->wooCommerceIntegrationInstance);

        $this->assertDatabaseHas(AccountingTransaction::class, [
            'link_type' => SalesOrder::class,
            'link_id' => $salesOrder->id,
            'is_sync_enabled' => true,
        ]);
    }
}