<?php

namespace Feature\Controllers;

use App\Models\SalesChannel;
use App\Models\SalesOrder;
use App\Models\SalesOrderFulfillment;
use App\Models\SalesOrderFulfillmentLine;
use App\Models\SalesOrderLine;
use App\Models\User;
use App\Models\Warehouse;
use Laravel\Sanctum\Sanctum;
use Modules\WooCommerce\Entities\WooCommerceIntegrationInstance;
use Modules\WooCommerce\Entities\WooCommerceOrder;
use Modules\WooCommerce\Tests\WooCommerceMockRequests;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class WooCommerceFulfillmentControllerTest extends TestCase
{
    use FastRefreshDatabase;
    use WooCommerceMockRequests;

    private WooCommerceIntegrationInstance $wooCommerceIntegrationInstance;

    public function setUp(): void
    {
        parent::setUp();
        $this->wooCommerceIntegrationInstance = WooCommerceIntegrationInstance::factory()
            ->has(SalesChannel::factory())
            ->create();

        Sanctum::actingAs(User::first());
    }

    public function test_woo_commerce_fulfillment_controller(): void
    {
        $this->mockFulfillOrder();

        $warehouse = Warehouse::first();

        $wooCommerceOrder = WooCommerceOrder::factory([
            'integration_instance_id' => $this->wooCommerceIntegrationInstance->id
            ])
            ->hasOrderItems()
            ->create();

        $salesOrder = SalesOrder::factory([
            'sales_channel_id' => $this->wooCommerceIntegrationInstance->salesChannel->id,
            'sales_order_number' => $wooCommerceOrder->orderId,
            'sales_channel_order_id' => $wooCommerceOrder->id,
            'sales_channel_order_type' => WooCommerceOrder::class
        ])
            ->has(SalesOrderLine::factory()->state([
                'sales_channel_line_id' => $wooCommerceOrder->orderItems->first()->lineItemId,
                'warehouse_id' => $warehouse->id,
            ]))
            ->create();

        $fulfillmentDate = now();

        $salesOrderFulfillment = SalesOrderFulfillment::factory([
            'sales_order_id' => $salesOrder->id,
            'warehouse_id' => $warehouse->id,
            'fulfilled_shipping_method' => 'USPS',
            'fulfilled_at' => $fulfillmentDate,
            'tracking_number' => '123456789',
        ])->has(SalesOrderFulfillmentLine::factory(1)->state([
            'sales_order_line_id' => $salesOrder->salesOrderLines->first()->id,
        ]))
        ->create();

        $salesOrderFulfillment->refresh();

        $this->postJson(route('woo-commerce.fulfill', [
            'integrationInstance' => $this->wooCommerceIntegrationInstance->id,
        ]), [
            'sales_order_fulfillment_id' => $salesOrderFulfillment->id,
        ])->assertStatus(200);

        $this->assertNotNull($salesOrderFulfillment->refresh()->submitted_to_sales_channel_at);
    }
}