<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Modules\WooCommerce\Http\Controllers\WooCommerceAuthenticationController;
use Modules\WooCommerce\Http\Controllers\WooCommerceOrderController;
use Modules\WooCommerce\Http\Controllers\WooCommerceProductController;

Route::prefix('export/woo-commerce/{integrationInstance}')->name('woo-commerce.')->group(function () {
    Route::get('/products', [WooCommerceProductController::class, 'exportForIntegration'])->name('products.export-download');
    Route::get('/orders', [WooCommerceOrderController::class, 'exportForIntegration'])->name('orders.export-download');
});

Route::post('woo-commerce/callback', [WooCommerceAuthenticationController::class, 'callback'])->name('woo-commerce.callback');