<?php

use Illuminate\Support\Facades\Route;
use Modules\Amazon\Http\Controllers\WooCommerceFulfillmentController;
use Modules\WooCommerce\Http\Controllers\WooCommerceAuthenticationController;
use Modules\WooCommerce\Http\Controllers\WooCommerceIntegrationInstanceController;
use Modules\WooCommerce\Http\Controllers\WooCommerceOrderController;
use Modules\WooCommerce\Http\Controllers\WooCommerceProductController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->group(function () {
    Route::salesChannel(
        'woo-commerce',
        WooCommerceProductController::class,
        WooCommerceOrderController::class,
        WooCommerceFulfillmentController::class,
        WooCommerceAuthenticationController::class,
        WooCommerceIntegrationInstanceController::class
    );
});

