<?php

namespace Modules\WooCommerce\Repositories;

use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Abstractions\Integrations\SalesChannels\AbstractSalesChannelOrderRepository;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Collection;
use Modules\Amazon\Enums\Entities\OrderStatusEnum;
use Modules\WooCommerce\Entities\WooCommerceIntegrationInstance;
use Modules\WooCommerce\Entities\WooCommerceOrder;
use Modules\WooCommerce\Entities\WooCommerceOrderItem;
use Modules\WooCommerce\Enums\WooCommerceOrderStatusEnum;

class WooCommerceOrderRepository extends AbstractSalesChannelOrderRepository
{
    protected static function getModelClassName(): string
    {
        return WooCommerceOrder::class;
    }

    protected static function getLinesModelClassName(): string
    {
        return WooCommerceOrderItem::class;
    }

    public function getCanceledOrders(IntegrationInstanceInterface $integrationInstance, ?Collection $collection = null): Collection
    {
        return parent::getCanceledOrdersQuery($integrationInstance, $collection)
            ->where('status', WooCommerceOrderStatusEnum::CANCELLED->value)
            ->get();
    }


}
