<?php

namespace Modules\WooCommerce\Managers;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Abstractions\Integrations\SalesChannels\AbstractSalesChannelOrderManager;
use App\Models\SalesOrderFulfillment;
use Modules\WooCommerce\ApiDataTransferObjects\WooCommerceFulfillOrderAdt;
use Modules\WooCommerce\Entities\WooCommerceIntegrationInstance;
use Modules\WooCommerce\Entities\WooCommerceOrder;
use Modules\WooCommerce\Repositories\WooCommerceOrderRepository;
use Modules\WooCommerce\Services\WooCommerceClient;

class WooCommerceOrderManager extends AbstractSalesChannelOrderManager
{
    private WooCommerceOrderRepository $wooCommerceOrderRepository;

    public function __construct(protected WooCommerceIntegrationInstance|IntegrationInstanceInterface $wooCommerceIntegrationInstance)
    {
        $this->wooCommerceOrderRepository = app(WooCommerceOrderRepository::class);

        $this->setModel(new WooCommerceOrder());

        parent::__construct($wooCommerceIntegrationInstance, new WooCommerceClient($this->wooCommerceIntegrationInstance), $this->wooCommerceOrderRepository);
    }

    protected function getOrderRepository()
    {
        return $this->wooCommerceOrderRepository;
    }

    protected function postProcess(?string $orderId = null)
    {
        // No post-processing required
    }

    protected function postProcessItems()
    {
        // No post-processing required
    }

    public function fulfillOrderForSalesOrderFulfillment(
        SalesOrderFulfillment $salesOrderFulfillment,
        ?ApiDataTransformerInterface $parameters = null
    ): void
    {
        $parameters = new WooCommerceFulfillOrderAdt($salesOrderFulfillment);
        parent::fulfillOrderForSalesOrderFulfillment($salesOrderFulfillment, $parameters);
    }
}
