<?php

namespace Modules\WooCommerce\Jobs;

use App\Models\SalesOrderFulfillment;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Modules\WooCommerce\Entities\WooCommerceIntegrationInstance;
use Modules\WooCommerce\Managers\WooCommerceOrderManager;

class WooCommerceFulfillmentJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(
        private readonly WooCommerceIntegrationInstance $integrationInstance,
        private readonly SalesOrderFulfillment $salesOrderFulfillment
    )
    {
    }

    /**
     * @throws Exception
     */
    public function handle(): void
    {
        (new WooCommerceOrderManager($this->integrationInstance))->fulfillOrderForSalesOrderFulfillment($this->salesOrderFulfillment);
    }
}
