<?php

namespace Modules\WooCommerce\Jobs;

use App\Abstractions\Integrations\ClientResponseDataInterface;
use Carbon\Carbon;
use Exception;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Modules\WooCommerce\ApiDataTransferObjects\WooCommerceGetProductsAdt;
use Modules\WooCommerce\Data\WooCommerceResponseData;
use Modules\WooCommerce\Entities\WooCommerceIntegrationInstance;
use Modules\WooCommerce\Jobs\Abstractions\WooCommerceJob;
use Modules\WooCommerce\Managers\WooCommerceProductManager;

class RefreshWooCommerceProductsJob extends WooCommerceJob implements ShouldBeUnique
{
    public string $uniqueId;

    public int $uniqueFor = 60 * 10;

    public function __construct(
        protected WooCommerceIntegrationInstance $wooCommerceIntegrationInstance,
        protected WooCommerceGetProductsAdt $parameters,
    ) {
        $this->uniqueId = get_class($this).':'.$this->wooCommerceIntegrationInstance->id;
    }

    /**
     * @throws Exception
     */
    public function apiCall(): WooCommerceResponseData|ClientResponseDataInterface
    {
        $this->parameters->nextPage = @$this->jobPayload['nextPage'];

        if ($modifiedAfter = @$this->jobPayload['modifiedAfterDateTime']) {
            $this->parameters->modified_after = Carbon::parse($modifiedAfter); // we need to avoid sanitizeDates because this is already in UTC
        }

        return (new WooCommerceProductManager($this->wooCommerceIntegrationInstance))
            ->refreshProducts($this->parameters);
    }
}
